﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface ITaskbarGroupSizeStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class TaskbarGroupSizeDefaultStrategy : ICorrespondenceOS, ITaskbarGroupSizeStrategy
    {
        public TaskbarGroupSizeDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG              
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "TaskbarGroupSize";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.CurrentUser.CreateSubKey(
                    @"Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced");

            registryKey.SetValue(RegName, i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.CurrentUser.OpenSubKey(
                    @"Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced");

            return new WFRegistry(@"HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced", RegName,
                              registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class TaskbarGroupSizeController
    {
        public TaskbarGroupSizeController(TaskbarGroupSize taskbarGroupSize,
                                                         ITaskbarGroupSizeStrategy strategy)
        {
            TaskbarGroupSize = taskbarGroupSize;
            Strategy = strategy;
        }

        public TaskbarGroupSize TaskbarGroupSize { get; set; }
        public ITaskbarGroupSizeStrategy Strategy { get; set; }

        public void Read()
        {
            TaskbarGroupSize.SetTaskbarGroupSizeValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(TaskbarGroupSize.GetTaskbarGroupSizeValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
